<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateGaleriVideo extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'judul' => [
                'type'       => 'VARCHAR',
                'constraint' => 150,
            ],
            'youtube_url' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
            ],
            'tahun' => [
                'type'       => 'VARCHAR',
                'constraint' => 10,
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);

        $this->forge->addKey('id', true);
        $this->forge->createTable('galeri_video');
    }

    public function down()
    {
        $this->forge->dropTable('galeri_video');
    }
}
